'use strict';
jQuery(function($) {
    $.fn.vcVioletBackground = function(Options, Callback) {
        var CreateElement = $(this);
        var ElementId = CreateElement.attr("id");
        var parentRow = getParentRow(CreateElement);
        parentRow.css("position", "relative");
        var Element = parentRow.prepend('<div id="' + ElementId + '" class="vc-violet-background-bg"><canvas id="' + ElementId + '-canvas"></canvas></div>');

        $("#" + ElementId).ultravioletBackground({
			trails: parseInt(CreateElement.attr("data-trails") ? CreateElement.attr("data-trails") : '20'),
		
			fixedHue: (CreateElement.attr("data-fixedhue") == "true"),
			hueSpeed: parseFloat(CreateElement.attr("data-huespeed") ? CreateElement.attr("data-huespeed") : '0.003'),
			hue: parseInt(CreateElement.attr("data-hue") ? CreateElement.attr("data-hue") : '20'),
			saturation: parseInt(CreateElement.attr("data-saturation") ? CreateElement.attr("data-saturation") : '90%') + "%",
			lightness: parseInt(CreateElement.attr("data-lightness") ? CreateElement.attr("data-lightness") : '50%') + "%",
			opacity: parseFloat(CreateElement.attr("data-opacity") ? CreateElement.attr("data-opacity") : '.25'),
			bgR: parseInt(CreateElement.attr("data-bgr") ? CreateElement.attr("data-bgr") : '30'),
			bgG: parseInt(CreateElement.attr("data-bgg") ? CreateElement.attr("data-bgg") : '30'),
			bgB: parseInt(CreateElement.attr("data-bgb") ? CreateElement.attr("data-bgb") : '70'),
		});

        CreateElement.remove();


        function getParentRow(Element) {
            return Element.parents(".boomapps_vcrow, .vc_row, .wpb_row").eq(0);
        }
    }


    $(".vc-violet-background").each(function() {

        $(this).vcVioletBackground();



    });



});